/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import satisfyu.beachparty.Beachparty;
import satisfyu.beachparty.BeachpartyIdentifier;
import satisfyu.beachparty.entity.CoconutEntity;
import satisfyu.beachparty.entity.chair.ChairEntity;
import satisfyu.beachparty.entity.pelican.PelicanEntity;

public class EntityRegistry {
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"beachparty", (ResourceKey)Registry.f_122903_);
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR = EntityRegistry.create("chair", () -> EntityType.Builder.m_20704_(ChairEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.001f, 0.001f).m_20712_(new BeachpartyIdentifier("chair").toString()));
    public static final RegistrySupplier<EntityType<PelicanEntity>> PELICAN = EntityRegistry.create("pelican", () -> EntityType.Builder.m_20704_(PelicanEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new BeachpartyIdentifier("pelican").toString()));
    public static final RegistrySupplier<EntityType<CoconutEntity>> COCONUT = EntityRegistry.create("coconut", () -> EntityType.Builder.m_20704_(CoconutEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new BeachpartyIdentifier("coconut").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new BeachpartyIdentifier(path), type);
    }

    public static void init() {
        Beachparty.LOGGER.debug("Registering Mod Entities for beachparty");
        ENTITY_TYPES.register();
        EntityRegistry.registerPelican();
    }

    public static void registerPelican() {
        EntityAttributeRegistry.register(PELICAN, PelicanEntity::createAttributes);
    }
}

